// URL of the RSS feed
const rssUrl = 'https://www.fun-fm.de/feed/';
const rssUrlSport = 'https://www.fun-fm.de/category/sport/feed/';
const rssUrlStudioblog = 'https://www.fun-fm.de/category/studioblog/feed/';
const rssUrlAV = 'https://www.fun-fm.de/category/aktuelles/videoaudio/feed/';
let defaultImageUrl = 'https://cdn.tbrmedia.de/sounds/backup_rss_image.jpg';

// Function to fetch the RSS feed data
const fetchRss = async () => {
    try {
        const response = await fetch(rssUrl);
        const data = await response.text();

        const parser = new DOMParser();
        const xml = parser.parseFromString(data, 'text/xml');

        const items = xml.querySelectorAll('item');
        const rssData = [];
        let count = 0;
        items.forEach(item => {
            if (count === 4) {
                return;
            }

            const title = item.querySelector('title').textContent;
            const link = item.querySelector('link').textContent;
            const pubDate = new Date(item.querySelector('pubDate').textContent);
            const pubDateFormatted = `${pubDate.getDate()}.${pubDate.getMonth() + 1}.${pubDate.getFullYear()}`;
            const author = item.querySelector('creator', 'xmlns:dc="http://purl.org/dc/elements/1.1/"').textContent;
            const description = item.querySelector('description').textContent;

            let imageUrl = defaultImageUrl;
            const itemContent = item.textContent || item.innerText;
            const imgRegex = /<img [^>]*src="([^"]+)"/;
            const match = imgRegex.exec(itemContent);

            if (match && match[1]) {
                imageUrl = match[1];

            } else {

            }



            rssData.push({
                title,
                link,
                pubDateFormatted,
                author,
                description,
                imageUrl
            });
            count++;
        });



        const topStory = rssData[0];
        const topStoryContainer = document.querySelector('#newsfeed-container-topstory');
        const topStoryBody = `
        <div class="col-12 newsfeed-container-topstory-col">
            <a href="${topStory.link}?mtm_campaign=ffmsounds&referrer=https://sounds.fun-fm.com" target="_blank">
                <figure class="newsfeed-card-topstory" style="background-image: url('${topStory.imageUrl}')">
                    <div class="newsfeed-card-topstory-textarea">
                    <h3 class="newsfeed-card-topstory-title">${topStory.title}</h3>
                    <div class="marker-show-aod"></div>
                        <p class="newsfeed-card-topstory-date">${topStory.pubDateFormatted}</p>
                        <p class="newsfeed-card-topstory-publisher">Von: ${topStory.author}</p>
                    </div>
                </figure>
            </a>
        </div>
        `;

        topStoryContainer.innerHTML = topStoryBody;


        // Add other stories
        const rssContainer = document.querySelector('#newsfeed-container');
        rssData.slice(1).forEach(item => {
            const card = document.createElement('div');
            card.classList.add('col-12', 'col-md-6', 'col-lg-4', 'mb-3', 'newsfeed-col');

            const cardBody = `
            <div class="card newsfeed-card">
                <div class="card-img-top newsfeed-img" style="background-image: url('${item.imageUrl}')"></div>
            <div class="card-body newsfeed-card-body">
                <h4 class="card-title newsfeed-card-title newsfeed-card-presentation-title" title="${item.title}">${item.title}</h4>
                <div class="marker-show-aod"></div>
                <p class="newsfeed-card-publishing">${item.pubDateFormatted} von: ${item.author}</p>
                <a href="${item.link}?mtm_campaign=ffmsounds&referrer=https://sounds.fun-fm.com" class="btn btn-funfm btn-newsfeed-card newsfeed-card-link" target="_blank">Weiterlesen...</a>
            </div>
            </div>
            `;





            card.innerHTML = cardBody;
            rssContainer.appendChild(card);

        });
    } catch (error) {
        console.error(error);
    }
};


const fetchRssSport = async () => {
    try {
        const response = await fetch(rssUrlSport);
        const data = await response.text();

        const parser = new DOMParser();
        const xml = parser.parseFromString(data, 'text/xml');

        const items = xml.querySelectorAll('item');
        const rssData = [];
        let count = 0;
        items.forEach(item => {
            if (count === 4) {
                return;
            }

            const title = item.querySelector('title').textContent;
            const link = item.querySelector('link').textContent;
            const pubDate = new Date(item.querySelector('pubDate').textContent);
            const pubDateFormatted = `${pubDate.getDate()}.${pubDate.getMonth() + 1}.${pubDate.getFullYear()}`;
            const author = item.querySelector('creator', 'xmlns:dc="http://purl.org/dc/elements/1.1/"').textContent;
            const description = item.querySelector('description').textContent;

            let imageUrl = defaultImageUrl;
            const itemContent = item.textContent || item.innerText;
            const imgRegex = /<img [^>]*src="([^"]+)"/;
            const match = imgRegex.exec(itemContent);

            if (match && match[1]) {
                imageUrl = match[1];

            } else {

            }



            rssData.push({
                title,
                link,
                pubDateFormatted,
                author,
                description,
                imageUrl
            });
            count++;
        });

        const rssContainer2 = document.querySelector('#newsfeed-sports-container');
        rssData.forEach(item => {
            const card = document.createElement('div');
            card.classList.add('col-12', 'col-md-3', 'mb-3', 'newsfeed-topic-col');

            const cardBody = `
            <a href="${item.link}?mtm_campaign=ffmsounds&referrer=https://sounds.fun-fm.com" target="_blank" class="newsfeed-card-link">
            <div class="card newsfeed-card newsfeed-topic-card">
                <div class="card-img-top newsfeed-img newsfeed-topic-img" style="background-image: url('${item.imageUrl}')"></div>
            <div class="card-body newsfeed-card-body newsfeed-topic-card-body" title="${item.title}">
                <h5 class="card-title newsfeed-card-title newsfeed-topic-card-title">${item.title}</h5>
            </div>
            </div>
            </a>
            `;



            card.innerHTML = cardBody;
            rssContainer2.appendChild(card);
        });
    } catch (error) {
        console.error(error);
    }
};

const fetchRssStudioblog = async () => {
    try {
        const response = await fetch(rssUrlStudioblog);
        const data = await response.text();

        const parser = new DOMParser();
        const xml = parser.parseFromString(data, 'text/xml');

        const items = xml.querySelectorAll('item');
        const rssData = [];
        let count = 0;
        items.forEach(item => {
            if (count === 4) {
                return;
            }

            const title = item.querySelector('title').textContent;
            const link = item.querySelector('link').textContent;
            const pubDate = new Date(item.querySelector('pubDate').textContent);
            const pubDateFormatted = `${pubDate.getDate()}.${pubDate.getMonth() + 1}.${pubDate.getFullYear()}`;
            const author = item.querySelector('creator', 'xmlns:dc="http://purl.org/dc/elements/1.1/"').textContent;
            const description = item.querySelector('description').textContent;

            let imageUrl = defaultImageUrl;
            const itemContent = item.textContent || item.innerText;
            const imgRegex = /<img [^>]*src="([^"]+)"/;
            const match = imgRegex.exec(itemContent);

            if (match && match[1]) {
                imageUrl = match[1];

            } else {

            }



            rssData.push({
                title,
                link,
                pubDateFormatted,
                author,
                description,
                imageUrl
            });
            count++;
        });

        const rssContainer3 = document.querySelector('#newsfeed-studioblog-container');
        rssData.forEach(item => {
            const card = document.createElement('div');
            card.classList.add('col-12', 'col-md-3', 'mb-3', 'newsfeed-topic-col');

            const cardBody = `
            <a href="${item.link}?mtm_campaign=ffmsounds&referrer=https://sounds.fun-fm.com" target="_blank" class="newsfeed-card-link">
            <div class="card newsfeed-card newsfeed-topic-card">
                <div class="card-img-top newsfeed-img newsfeed-topic-img" style="background-image: url('${item.imageUrl}')"></div>
            <div class="card-body newsfeed-card-body newsfeed-topic-card-body" title="${item.title}">
                <h5 class="card-title newsfeed-card-title newsfeed-topic-card-title">${item.title}</h5>
            </div>
            </div>
            </a>
            `;



            card.innerHTML = cardBody;
            rssContainer3.appendChild(card);
        });
    } catch (error) {
        console.error(error);
    }
};

const fetchRssAV = async () => {
    try {
        const response = await fetch(rssUrlAV);
        const data = await response.text();

        const parser = new DOMParser();
        const xml = parser.parseFromString(data, 'text/xml');

        const items = xml.querySelectorAll('item');
        const rssData = [];
        let count = 0;
        items.forEach(item => {
            if (count === 4) {
                return;
            }

            const title = item.querySelector('title').textContent;
            const link = item.querySelector('link').textContent;
            const pubDate = new Date(item.querySelector('pubDate').textContent);
            const pubDateFormatted = `${pubDate.getDate()}.${pubDate.getMonth() + 1}.${pubDate.getFullYear()}`;
            const author = item.querySelector('creator', 'xmlns:dc="http://purl.org/dc/elements/1.1/"').textContent;
            const description = item.querySelector('description').textContent;

            let imageUrl = defaultImageUrl;
            const itemContent = item.textContent || item.innerText;
            const imgRegex = /<img [^>]*src="([^"]+)"/;
            const match = imgRegex.exec(itemContent);

            if (match && match[1]) {
                imageUrl = match[1];

            } else {

            }



            rssData.push({
                title,
                link,
                pubDateFormatted,
                author,
                description,
                imageUrl
            });
            count++;
        });

        const rssContainer4 = document.querySelector('#newsfeed-av-container');
        rssData.forEach(item => {
            const card = document.createElement('div');
            card.classList.add('col-12', 'col-md-3', 'mb-3', 'newsfeed-topic-col');

            const cardBody = `
            <a href="${item.link}?mtm_campaign=ffmsounds&referrer=https://sounds.fun-fm.com" target="_blank" class="newsfeed-card-link">
            <div class="card newsfeed-card newsfeed-topic-card">
                <div class="card-img-top newsfeed-img newsfeed-topic-img" style="background-image: url('${item.imageUrl}')"></div>
            <div class="card-body newsfeed-card-body newsfeed-topic-card-body" title="${item.title}">
                <h5 class="card-title newsfeed-card-title newsfeed-topic-card-title">${item.title}</h5>
            </div>
            </div>
            </a>
            `;


            card.innerHTML = cardBody;
            rssContainer4.appendChild(card);
        });
    } catch (error) {
        console.error(error);
    }
};

// Call the fetchRss function to start the process
// window.addEventListener('load', fetchRss);