const promotionUrl= 'https://hearthis.at/set/245962-1849159/podcast/';

const fetchpromoAOD = async () => {
    try {
        const response = await fetch(promotionUrl);
        const data = await response.text();

        const parser = new DOMParser();
        const xml = parser.parseFromString(data, 'text/xml');

        const items = xml.querySelectorAll('item');
        const rssData = [];
        let count = 0;
        items.forEach(item => {
            if (count === 25) {
                return;
            }

            const link = item.querySelector('link').textContent;
            const pubDate = new Date(item.querySelector('pubDate').textContent);
            const pubDateFormatted = `${pubDate.getDate()}.${pubDate.getMonth() + 1}.${pubDate.getFullYear()}`;

            const title = item.querySelector('title').textContent;
            const description = item.querySelector('description').textContent;
            const imageElement = item.getElementsByTagName('itunes:image')[0];
            const image = imageElement ? imageElement.getAttribute('href') : '';
            const audioElement = item.getElementsByTagName('media:content')[0];
            const audio = audioElement ? audioElement.getAttribute('url') : '';


            rssData.push({
                title,
                audio,
                description,
                image
            });
            count++;
        });

        const rssContainer = document.querySelector('#show-promotions-table-content');
        rssData.forEach(item => {
            const episodeslist = document.createElement('tr');

            const episodecontent = `
            
            <td class="episode-image">
                <img class="show-promo-episode-image" src="${item.image}"/>
            </td>
            <td class="episode-controls">
                <button class="episode-button" data-streaming="${item.audio}" data-name="${item.title}" data-image="${item.image}"><span class="material-icons">play_circle_outline</span></button>
            </td>
            <td class="episode-text">
                <p class="episode-title">${item.title}</p>
                <p class="episode-description">${item.description}</p>
            </td>
            `;



            episodeslist.innerHTML = episodecontent;
            rssContainer.appendChild(episodeslist);
        });
    } catch (error) {
        console.error(error);
    }
};