function $_GET(param) {
    let vars = {};
    window.location.href.replace(location.hash, '').replace(
        /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
        function (m, key, value) { // callback
            vars[key] = value !== undefined ? value : '';
        }
    );

    if (param) {
        return vars[param] ? vars[param] : null;
    }
    return vars;
}

function handleApiError(_function) {
    try{
        _function;
    } catch (e) {
        console.error(e);
    }
}

function setCurrentPlaylist(apiData) {
    $(".popout-show_timing").html(apiData.current_playlist.hour + ' &ndash; ' + apiData.next_playlist.hour + ' Uhr');
    $(".popout-show_name").html(apiData.current_playlist.name);
    let themingImage = 'https://static.tbrnet.de/images/funfm/sounds/cover/'+apiData.current_playlist.id+'.png';
    $(".popout-body")[0].style.background = 'url('+themingImage+')';
    $(".popout-show_cover")[0].src = themingImage;
}


function crawleLautApi(station_name) {
    $.getJSON("https://api.laut.fm/station/" + station_name, function (data) {
        changeFavicon(data);
        createWebApp(data);
        document.title = data.display_name.toUpperCase() + " - SOUNDS";
        current_show && setCurrentPlaylist(data);
    });
}

function crawlePlaylist(station_name) {
    $.getJSON("https://api.laut.fm/station/" + station_name, function (data) {
        current_show && setCurrentPlaylist(data);
    });
}

function changeFavicon(apiData) {
    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link = document.createElement('link'),
        oldLink = document.getElementById('dynamic-favicon');
    link.id = 'dynamic-favicon';
    link.rel = 'shortcut icon';
    link.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand.png';
    if (oldLink) {
        document.head.removeChild(oldLink);
    }
    document.head.appendChild(link);
}

function createWebApp(apiData) {
    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link1 = document.createElement('link'),
        oldLink1 = document.getElementById('dynamic-webapp-1');
    link1.id = 'dynamic-webapp-1';
    link1.rel = 'icon';
    link1.type = 'image/png';
    link1.size = '96x96';
    link1.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand.png';
    if (oldLink1) {
        document.head.removeChild(oldLink1);
    }
    document.head.appendChild(link1);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link2 = document.createElement('link'),
        oldLink2 = document.getElementById('dynamic-webapp-2');
    link2.id = 'dynamic-webapp-2';
    link2.rel = 'icon';
    link2.type = 'image/png';
    link2.size = '32x32';
    link2.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand.png';
    if (oldLink2) {
        document.head.removeChild(oldLink2);
    }
    document.head.appendChild(link2);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link3 = document.createElement('meta'),
        oldLink3 = document.getElementById('dynamic-webapp-3');
    link3.id = 'dynamic-webapp-3';
    link3.name = 'theme-color';
    link3.content = '#141414';
    if (oldLink3) {
        document.head.removeChild(oldLink3);
    }
    document.head.appendChild(link3);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link4 = document.createElement('link'),
        oldLink4 = document.getElementById('dynamic-webapp-4');
    link4.id = 'dynamic-webapp-4';
    link4.rel = 'apple-touch-icon';
    link4.size = '180x180';
    link4.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand@2x.png';
    if (oldLink4) {
        document.head.removeChild(oldLink4);
    }
    document.head.appendChild(link4);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link5 = document.createElement('meta'),
        oldLink5 = document.getElementById('dynamic-webapp-5');
    link5.id = 'dynamic-webapp-5';
    link5.name = 'msapplication-TileColor';
    link5.content = '#141414';
    if (oldLink5) {
        document.head.removeChild(oldLink5);
    }
    document.head.appendChild(link5);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link6 = document.createElement('meta'),
        oldLink6 = document.getElementById('dynamic-webapp-6');
    link6.id = 'dynamic-webapp-6';
    link6.name = 'msapplication-TileImage';
    link6.content = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand@2x.png';
    if (oldLink6) {
        document.head.removeChild(oldLink6);
    }
    document.head.appendChild(link6);

    document.head || (document.head = document.getElementsByTagName('head')[0]);
    let link7 = document.createElement('link'),
        oldLink7 = document.getElementById('dynamic-webapp-7');
    link7.id = 'dynamic-webapp-7';
    link7.rel = 'shortcut icon';
    link7.sizes = '1024x1024';
    link7.href = 'https://static.tbrnet.de/images/funfm/sounds/logos/appicond_brand@4x.png';
    if (oldLink7) {
        document.head.removeChild(oldLink7);
    }
    document.head.appendChild(link7);
}

function getSong(station_name) {
    $.getJSON("https://api.laut.fm/station/" + station_name + "/current_song", function (current) {
        if (song_str !== (current.title + " " + current.artist.name)) {
            song_str = current.title + " " + current.artist.name;
            $(".popout_artist").html(current.artist.name);
            $(".popout_title").html(current.title);
        }
    })
}

function audiobtn() {
    let aud = $('video')[0];
    aud.src = 'https://stream.laut.fm/' + station;
    aud.title = sender + ' - LIVE';
    $('.btn-popout_playbtn').on('click', function () {
        if (aud.paused) {
            aud.play();
            $('.play-pause').removeClass('fa-play').addClass('fa-stop');
        } else {
            aud.pause();
            $('.play-pause').removeClass('fa-stop').addClass('fa-play');
        }

    })
}


window.setInterval(CheckPlayerState, 5000);

function CheckPlayerState() {
    let aud = $('video')[0];
    if (aud.paused) {
    } else {
        updateMetadata();
    }
}

function updateMetadata() {
    $.getJSON("https://api.laut.fm/station/" + station + "/current_song", function (current) {
        let npartist = current.artist.name;
        let nptitle = current.title;
        navigator.mediaSession.metadata = new MediaMetadata({
            title: nptitle,
            artist: npartist,
            album: 'FUN FM',
        });
        if (nptitle=='DIE NACHRICHTEN') {
            $.getJSON("https://api.laut.fm/station/" + station , function (apiData) {
                navigator.mediaSession.metadata = new MediaMetadata({
                    title: nptitle,
                    artist: npartist,
                    album: 'FUN FM',
                    artwork: [{src: 'https://static.tbrnet.de/images/funfm/cover/Nachrichten.jpg'}],
                });
            });
        } if (nptitle=='DAS WETTER') {
            $.getJSON("https://api.laut.fm/station/" + station , function (apiData) {
                navigator.mediaSession.metadata = new MediaMetadata({
                    title: nptitle,
                    artist: npartist,
                    album: 'FUN FM',
                    artwork: [{src: 'https://static.tbrnet.de/images/funfm/cover/Wetter.jpg'}],
                });
            });
        } else {
            $.getJSON("https://api.laut.fm/station/" + station , function (apiData) {
                navigator.mediaSession.metadata = new MediaMetadata({
                    title: nptitle,
                    artist: npartist,
                    album: 'FUN FM',
                    artwork: [{src: 'https://static.tbrnet.de/images/funfm/cover/Cover.jpg'}],
                });
            });
        }
    });
}

