<!DOCTYPE html>
<html lang="de" xmlns="http://www.w3.org/1999/html">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <link rel="stylesheet" href="assets/css/loader.min.css">

    <!--WebApp Basics-->
    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
</head>

<body>
<!--Navigation-->

<!--Broadcast Bar-->
<nav class="broadcastbar fixed-top">
    <div class="container">
        <div class="row no-gutters">
            <div class="col-md-3 col-lg-2 d-flex d-md-block justify-content-center mb-2 mb-md-0">
                <button type="button" class="player-button playbtn btn-floating"><i class="fas play-pause fa-play"></i></button>
                <button type="button" class="mute-button mutebtn btn-floating"><i class="fas mute-unmute fa-volume-up"></i></button>
                <div class="icon audio hidden">
                    <i></i>
                </div>
            </div>
            <div class="col-md-9 col-lg-10 d-flex align-items-center" id="nowplaying">
                <div class="d-inline-block"><span id="api_lfm_display_name"></span>&nbsp;spielt:&nbsp;</div>
                <div id="api_lfm_current_song1"></div>
            </div>
        </div>
    </div>
</nav>

<!--Show Header -->
<section id="show_header" class="show-header d-none d-sm-none d-md-block">
    <div class="container-fluid show-header-content">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <img src="https://static.tbrnet.de/images/funfm/Logo/Logo%20White-noborder.png" alt="FUN FM Logo" class="funfm-logo-top">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <h5 class="show_start show_buehne"></h5>
                    <h2 class="show_name show_buehne"></h2>
                    <div class="marker"></div><br/>
                    <p class="show_description"></p>
                    <button type="button" class="btn livebtn btn-funfm"><i class="fas fa-play"></i> Radio Einschalten</button>
                </div>
                <div class="col-md-6 text-right">
                    <h5 class="next_start show_buehne"></h5>
                    <h2 class="next_name show_buehne"></h2>
                    <div class="marker-right"></div><br/>
                    <p class="next_description"></p>
                </div>
            </div>
            <!--<div class="row"><div class="col-md-12"><div class="progress showprogress"><div class="progress-bar show-progress" role="progressbar" style="width: 75%;" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div></div></div></div>-->
        </div>
    </div>
</section>

<!--Station Infos-->
<section id="station_info">
<div id="station" class="container">
	<div class="row">
		<div class="col-md-3 mt-5 mt-md-4">
			<img id="station_logo" class="station_logo z-depth-1-half img-fluid" alt="Station Logo"/>
		</div>
		<div class="col-md-5 mt-4 station_info_container" id="station_info">
			<div class="station_details_container z-depth-1-half">
				<h2 id="station_displayname"></h2>
				<h4 id="station_slogan"></h4>
				<p id="station_description"></p>
				<div class="station_details_links d-sm-block d-md-none">
                    <a class="social-link link-lfm" id="lfm-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fas fa-headphones"></i></a>
					<a class="social-link link-hp" id="hp-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fas fa-globe-europe"></i></a>
					<a class="social-link link-fb" id="fb-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fab fa-facebook-f"></i></a>
					<a class="social-link link-tw" id="tw-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fab fa-twitter"></i></a>
					<a class="social-link link-ig" id="ig-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fab fa-instagram"></i></a>
                    <a class="social-link link-rss" id="rss-link" target="_blank" rel="external nofollow noopener noreferrer"><i class="fas fa-rss"></i></a>
				</div>
                <div class="btn-group btn_external d-none d-sm-none d-md-flex" role="group" aria-label="Playlist Links">
                    <a class="external_listening btn btn-sm btn-grey" type="button" id="radiode-link" rel="external nofollow noopener noreferrer">radio.de</a>
                    <a class="external_listening btn btn-sm btn-grey" type="button" id="phonostar-link" rel="external nofollow noopener noreferrer">phonostar</a>
                    <a class="external_listening btn btn-sm btn-grey" type="button" id="tunein-link" rel="external nofollow noopener noreferrer">tunein</a>
                    <a class="external_listening btn btn-sm btn-grey" type="button" id="m3u-link" rel="external nofollow noopener noreferrer">M3U</a>
                    <a class="external_listening btn btn-sm btn-grey" type="button" id="pls-link" rel="external nofollow noopener noreferrer">PLS</a>
                </div>
			</div>
		</div>
		<div class="col-md-4 mt-4 station_info_container" id="playlist_wrapper">
			<div id="current_show" class="current_show_container z-depth-1-half mb-4">
				<h4 class="show_start"></h4>
				<h3 class="show_name"></h3>
				<p class="show_description"></p>
			</div>
			<div id="next_show" class="current_show_container z-depth-1-half">
				<h4 class="next_start"></h4>
				<h3 class="next_name"></h3>
				<p class="next_description"></p>
			</div>

		</div>
	</div>
</div>
</section>

<!-- Song history -->
<section id="cover-flow">
<div class="container" id="last_songs">
    <div class="row">
        <div class="col-7 mt-5 mt-md-4">
            <h3 class="d-flex">Letzte Songs:</h3>
        </div>
        <div class="col-5 mt-5 mt-md-4 align-items-baseline">
            <a href="https://www.fun-fm.de/songfinder" class="d-flex align-self-end justify-content-end align-items-end align-self-end row-end-link" target="_blank">Zum Songfinder&nbsp;&nbsp;<i class="fas fa-chevron-right"></i></a>
        </div>
    </div>
</div>
<div class="container-fluid scrolls" id="last_songs">
    <div id="song_row" class="row scrolls"></div>
</div>

<br/>
</section>

<!-- Audio on Demand -->
<section id="aod" class="d-none d-sm-none d-md-block">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <h3 class="aod-heading">On Demand:</h3>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row aod-row scrolls">
            <div class="col-md-6">
                <div id="news" class="current_show_container news_container aod-container z-depth-1-half">
                    <div class="aod-content">
                        <h5 id="news_head_1" class="aod-headline">Auf dem neusten Stand</h5>
                        <h3 id="news_head_2" class="aod-headline">Die Nachrichten</h3>
                        <div class="marker-aod"></div>
                        <button type="button" class="btn btn-sm newsbtn btn-funfm"><i class="fas fa-play"></i> Anh&ouml;ren</button>
                    </div>
                </div>
            </div>
            <!--<div class="col-md-3">
                <div id="news" class="current_show_container wirtschaft_container aod-container z-depth-1-half">
                    <div class="aod-content">
                        <h5 id="news_head_1" class="aod-headline">Vom 19.10.21</h5>
                        <h3 id="news_head_2" class="aod-headline">Wirtschaftsnews</h3>
                        <div class="marker-aod"></div>
                        <button type="button" class="btn btn-sm wirtschaft-1-btn btn-funfm"><i class="fas fa-play"></i> Anh&ouml;ren</button>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div id="news" class="current_show_container wirtschaft_container aod-container z-depth-1-half">
                    <div class="aod-content">
                        <h5 id="news_head_1" class="aod-headline">Vom 15.10.21</h5>
                        <h3 id="news_head_2" class="aod-headline">Wirtschaftsnews</h3>
                        <div class="marker-aod"></div>
                        <button type="button" class="btn btn-sm wirtschaft-1-btn btn-funfm"><i class="fas fa-play"></i> Anh&ouml;ren</button>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div id="news" class="current_show_container wirtschaft_container aod-container z-depth-1-half">
                    <div class="aod-content">
                        <h5 id="news_head_1" class="aod-headline">Vom 12.10.21</h5>
                        <h3 id="news_head_2" class="aod-headline">Wirtschaftsnews</h3>
                        <div class="marker-aod"></div>
                        <button type="button" class="btn btn-sm wirtschaft-1-btn btn-funfm"><i class="fas fa-play"></i> Anh&ouml;ren</button>
                    </div>
                </div>
            </div>-->
        </div>
    </div>
</section>
<br/>

<!-- Sendeplan -->
<section id="schedule">
    <? //include 'module/schedule.inc.php';?>
</section>

<!-- Footer -->
<footer class="page-footer font-small grey">
    <div class="container p-4">
        <div class="row">
            <div class="col-md-7">
                <h2 class="mb-3">Folge uns:</h2>
                <div class="station_details_links">
                    <a class="social-link-2 link-fb" id="fb-link" target="_blank" rel="external nofollow noopener noreferrer" href="https://www.facebook.com/funfm.de"><i class="fab fa-facebook-f"></i></a>
                    <a class="social-link-2 link-tw" id="tw-link" target="_blank" rel="external nofollow noopener noreferrer" href="https://twitter.com/fun_fm"><i class="fab fa-twitter"></i></a>
                    <a class="social-link-2 link-ig" id="ig-link" target="_blank" rel="external nofollow noopener noreferrer" href="https://instagram.com/funfm.de"><i class="fab fa-instagram"></i></a>
                    <a class="social-link-2 link-yt" id="yt-link" target="_blank" rel="external nofollow noopener noreferrer" href="https://www.youtube.com/user/funfm00"><i class="fab fa-youtube"></i></a>
                    <a class="social-link-2 link-rss" id="rss-link" target="_blank" rel="external nofollow noopener noreferrer" href="http://www.fun-fm.de/feed/"><i class="fas fa-rss"></i></a>
                </div>
            </div>
            <div class="col-md-5">
                <p style="padding-top: 10px; margin-bottom: 4px;">&copy; FUN FM</p>
                <p style="margin-bottom: 4px;">This station is powered by:</p>
                <a href="https://laut.fm/" rel="external nofollow noopener noreferrer">
                    <img src="assets/img/lautfm.svg" style="height: 40px; margin-bottom: 20px;" alt="" class="lautfm-logo"/>
                </a>
            </div>
        </div>
    </div>

</footer>
<!-- Footer -->

<audio class="live-player" id="audio" preload="none"></audio>

<script src="assets/js/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js" integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo" crossorigin="anonymous"></script>
<script src="assets/js/mdb/mdb.js"></script>
<script src="assets/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/js/fontawesome/all.min.js"></script>
<script src="assets/js/jquery.khan-shatyr.min.js"></script>
<script src="assets/js/lfmplayer.js"></script>
<script src="assets/js/tracklist.js"></script>
<script>
    /* =========================
     *  $_GET vars and checks
     * ========================= */
    let station         = 'funfm',
        color           = 'ffcc00'            || 'ffcc00';

    /* Boolean */
    let badges          = $_GET('badges')           || true,
        station_info    = $_GET('station_info')     || true,
        current_show    = $_GET('current_show')     || true,
        next_show       = $_GET('next_show')        || true,
        history         = $_GET('history')          || true,
        cover           = 'true'           || true;

    /* $_GET vars checks and translation */
    (badges == 'true' || badges == 'false')             ? badges = (badges == 'true')               : badges = true;
    (current_show == 'true' || current_show == 'false') ? current_show = (current_show == 'true')   : current_show = true;
    (next_show == 'true' || next_show == 'false')       ? next_show = (next_show == 'true')         : next_show = true;
    (station_info == 'true' || station_info == 'false') ? station_info = (station_info == 'true')   : station_info = true;
    (history == 'true' || history == 'false')           ? history = (history == 'true')             : history = true;
    (cover == 'true' || cover == 'false')               ? cover = (cover == 'true')                 : cover = false;


    /* =========================
     *  Other things
     * ========================= */

    /* Hide not wanted stuff from $_GET */
    !current_show   && $('#current_show').hide();
    !next_show      && $('#next_show').hide();
    !station_info   && $(function () {$('#station').hide(); $('#last_songs').css("margin-top", "5rem")});
    !history        && $('#last_songs').hide();

    if (!current_show && !next_show) {
        $("#playlist_wrapper").addClass("d-none");
        $("#station_info").removeClass("col-md-5").addClass("col-md-9");
    }

    let root = document.documentElement,
        sender = station.toUpperCase(),
        last_song_data_cache,
        song_str;
    root.style.setProperty('--main-color', '#' + color);
    !station && $("#api_lfm_current_song1").html("<artist>No Station Name given</artist>");

    function cycle() {
        setTimeout(function () {
            history && load_last_song(station);
            $('[data-toggle="popover"]').popover({trigger: 'focus'});
            getSong(station);
            crawlePlaylist(station);
            cycle();
        }, 2000);
    }

    $(document).ready(function () {
        audiobtn();
        history && load_last_songs_fully(station);
        crawleLautApi(station);
        getSong(station);
        getWidth();
        $("#api_lfm_current_song1").khanShatyr({delay: 2000, pause: 300, max_kerning: -0.05}).css('color', 'white');
        cycle();
    });
</script>

<script type="text/template" id="song_detailed">
    <div class="col-md-4">
        <div class="last_song d-flex z-depth-1-half">
            <span class="track_nr">{{track_nr}}</span>
            <div class="song_wrapper">
                <h4 class="last_text last_artist">
                    {{artist}}
                </h4>
                <p class="last_text last_title">
                    {{title}}
                </p>
            </div>
            <div class="last_btn">
                <a tabindex="0" role="button" data-toggle="popover" data-trigger="focus" title="{{artist}}" data-content="{{title}}">
                    <i class="fas fa-info-circle"></i>
                </a>
            </div>
        </div>
    </div>
</script>
<script type="text/template" id="song_detailed_cover">
        <div class="card text-white last_song d-inline-block">
            <img src="{{cover}}" class="card-img cover" alt=""/>
            <div class="card-img-overlay song_wrapper mask" style="background: linear-gradient(to bottom, rgba(0, 0, 0, 0.1) 0%, rgba(0,0,0,0.4) 80%); border-radius: 3px">
                <!--<p class="card-text last_text last_time">&nbsp;{{time}}</p>-->
                <h3 class="card-title last_text last_artist">{{artist}}</h3>
                <p class="card-text last_text last_title">{{title}}</p>
                <div class="last_btn">
                    <a tabindex="0" role="button" data-toggle="popover" data-trigger="focus" title="{{artist}}" data-content="{{title}}">
                        <i class="fas fa-info-circle"></i>
                    </a>
                </div>
            </div>
        </div>
</script>
</body>
</html>
