<div id="lfm_schedule" class="lfm_schedule">
    <div class="container">
        <div class="row">
            <div class="col-12 schedule-day-row">
                <button class="btn schedule-selector">Montag</button>
                <button class="btn schedule-selector">Dienstag</button>
                <button class="btn schedule-selector">Mittwoch</button>
                <button class="btn schedule-selector">Donnerstag</button>
                <button class="btn schedule-selector">Freitag</button>
                <button class="btn schedule-selector">Samstag</button>
                <button class="btn schedule-selector">Sonntag</button>
            </div>
        </div>
        <br/>

        <div class="row">
            <div class="col-12 schedule-day-content">
                <div class="schedule-tab">
                    <div class="api_lfm_schedule">Loading...</div>
                </div>
                <div class="schedule-tab">
                    <div class="api_lfm_schedule">Loading...</div>
                </div>
                <div class="schedule-tab">
                    <div class="api_lfm_schedule">Loading...</div>
                </div>
                <div class="schedule-tab">
                    <div class="api_lfm_schedule">Loading...</div>
                </div>
                <div class="schedule-tab">
                    <div class="api_lfm_schedule">Loading...</div>
                </div>
                <div class="schedule-tab">
                    <div class="api_lfm_schedule">Loading...</div>
                </div>
                <div class="schedule-tab">
                    <div class="api_lfm_schedule">Loading...</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    var tablinks = Array.prototype.slice.call(document.getElementsByClassName("schedule-selector"));
    var tabs = Array.prototype.slice.call(document.getElementsByClassName("api_lfm_schedule"));
    var tabcontent = Array.prototype.slice.call(document.getElementsByClassName("schedule-tab"));
    function openDAY(day) {
        var i;
        for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].className = tabcontent[i].className.replace("-active", "");
        }
        for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" schedule-selector-selected", "");
        }
        tabcontent[day].className += "-active";
        tablinks[day].className += " schedule-selector-selected";
    }

    tablinks.forEach(function (tablink, day) {
        tablink.addEventListener('click', function() {
            openDAY(day)
        })
    })

    jQuery(document).ready(function($) {
        $(document).ready(function() {
            function update_data() {
                $.ajax({
                    type: "GET",
                    url: "https://api.laut.fm/station/" + station + "/schedule",
                    dataType: "json",
                    timeout: 5000,
                }).done(function(schedule) {
                    var get_day = (new Date().getDay() || 7) - 1;
                    openDAY(get_day)
                    if (schedule[0].end_time === null) {
                        document.getElementsByClassName('lfm_schedule')[0].style.display = 'inline';
                        document.getElementById('lfm_schedule').innerHTML = '<div class="lfm_schedule_no_entry">Der Sendeplan kann aktuell nicht angezeigt werden</div>';
                    } else {
                        document.getElementsByClassName('lfm_schedule')[0].style.display = 'inline';
                        var no_entry = '<div class="no_entry">Leider keine Sendung</div>';
                        var days = ['mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun'];
                        var days_buffer = {mon: [], tue: [], wed: [], thu: [], fri: [], sat: [], sun: []};
                        var groupLength = schedule.length;
                        Array.prototype.slice.call(schedule).forEach(function(schedule_entry, index) {
                            var show_id = schedule_entry.id;
                            var start_time = schedule_entry.hour;
                            if (start_time < 10) { start_time = start_time }
                            var end_time = schedule_entry.end_time;
                            if (end_time < 10) { end_time = '0' + end_time }
                            start_time = start_time + ':00 Uhr';
                            end_time = end_time + ':00 Uhr';
                            var programme_progress = '0';
                            if(index + 1 === groupLength) {
                                var entryindex = "theend";
                            } else {
                                var entryindex = (index + 1);
                            }
                            if (schedule_entry.day === days[get_day] && schedule_entry.hour <= new Date().getHours()) {
                                if (entryindex === "theend" || schedule[entryindex].day === days[get_day] && schedule[entryindex].hour > new Date().getHours() || schedule[entryindex].day != days[get_day]) {
                                    days_buffer[schedule_entry.day].push('<div class="row show-row show-row-current" id="onair"><div class="col show-col image-col image-col-current" style="background-image: url(https://cdn.tbrmedia.de/sounds/funfm/showcover/'+show_id+'.png)"><div class="progress schedule-current-programme-time"><div class="progress-bar schedule-current-programme-time-progress" role="progressbar"  style="width: '+programme_progress+'%" aria-valuemin="0" aria-valuemax="100"></div></div><div class="sched-current"><svg viewBox="0 0 368 112" xmlns="http://www.w3.org/2000/svg" class="sched-onair"><path d="M118 25.72C104.16 25.72 90.56 34.84 90.56 54.92C90.56 76.04 105.44 84.28 118 84.28C131.92 84.28 145.44 74.92 145.44 55.08C145.44 33.72 130.64 25.72 118 25.72ZM118 36.04C127.52 36.04 132.64 43.64 132.64 55.16C132.64 67.16 126.32 73.96 118 73.96C108.56 73.96 103.36 66.6 103.36 54.84C103.36 43.08 109.44 36.04 118 36.04ZM187.36 27V64.92L166.96 27H152.72V83H163.84V45.56L184.64 83H198.48V27H187.36ZM269.33 83L251.33 27H236.93L218.93 83H231.81L234.61 73.24H253.33L256.05 83H269.33ZM237.41 63.4L243.97 38.36L250.61 63.4H237.41ZM272.696 27V36.84H278.856V73.16H272.696V83H297.336V73.16H291.176V36.84H297.336V27H272.696ZM351.127 83L336.087 61.24C343.447 58.36 347.607 52.76 347.607 45.32C347.607 34.92 339.447 27 324.087 27H305.767V83H318.167V63.4H324.087L336.887 83H351.127ZM325.207 37.16C330.647 37.16 334.807 40.44 334.807 45.32C334.807 51.4 330.727 54.28 324.967 54.28H318.167V37.16H325.207Z"/><path d="M19.8918 28V84L74.7004 56.0299L19.8918 28Z" class="sched-onair-animated"/></svg></div></div><td rowspan="2" class="lfm_api_schedule_time"><div class="col show-col show-info-col"><h5 class="show-start">' + start_time + '</h5><h3 class="show-name">' + schedule_entry.name + '</h3><p class="show-description">' + schedule_entry.description + '</p></div></div>');
                                } else {
                                    days_buffer[schedule_entry.day].push('<div class="row show-row">' + '<div class="col show-col image-col" style="background-image: url(https://cdn.tbrmedia.de/sounds/funfm/showcover/'+show_id+'.png)"></div><div class="col show-col show-info-col"><h5 class="show-start">' + start_time + '</h5><h3 class="show-name">' + schedule_entry.name + '</h3><p class="show-description">' + schedule_entry.description + '</p></div></div>');
                                }
                            } else {
                                days_buffer[schedule_entry.day].push('<div class="row show-row">' + '<div class="col show-col image-col" style="background-image: url(https://cdn.tbrmedia.de/sounds/funfm/showcover/'+show_id+'.png)"></div><div class="col show-col show-info-col"><h5 class="show-start">' + start_time + '</h5><h3 class="show-name">' + schedule_entry.name + '</h3><p class="show-description">' + schedule_entry.description + '</p></div></div>');
                            }
                        });
                        Array.prototype.slice.call(tabs).forEach(function(tab, index) {
                            if (days_buffer[days[index]].length >= 1) {
                                tab.innerHTML = days_buffer[days[index]].join('');
                            } else {
                                tab.innerHTML = no_entry;
                            }
                        });
                    }
                }).fail(function(xhr, status, error) {
                    $('.api_lfm_station_listeners' + s_id[station_number] + '').html(obj.error_message);
                    console.warn('Warning (API): Listeners reports: ' + xhr.status + ' ' + error + ' | Station name: /' + stations_array);
                });
            }
            update_data();
            setInterval(update_data, 30000);
        });
    });
</script>
<script type="text/javascript" src="assets/js/jquery-3_4_1.js"></script>
<br/>